﻿/*****************************************************************************
 * Name: Your Name
 * Class: CPMS 378, 
 * Assignment #: 2, Infinite Series
 * Date Due: Today Date
 * Problem Description:   To calculate and compute the values based
 * on the formula of e^x and compare the values to the Math class
 * power method of e^x. This program creates asks the user for the
 * value of x and for the number of iterations to calculate for. The
 * main() method uses a while loop to check that the iteration value
 * is not a negative number or 0. An InfiniteSeries object is then 
 * created using the values and calls the Calculate() method from
 * the class to make the computation based on the series formula.
 * 
 * Input:
 * Type     Variable        Description
 * int      x               // Number to hold exponent value for e^x
 * int      n               // Number of terms to calculate in the series, not including the first term
 * 
 * Output:
 * Type     Variable        Description
 * double   sum             // The sum of the first n+1 terms of the series
 * double   exp             // Uses the Math.Pow class to calculate formula (similar to sum)
 * double   diff            // Calculates the difference between sum and exp
 * ***************************************************************************/

using System;

namespace Project2
{
    // The InfiniteSeries class is constructed using two integer parameters that will
    // be used for the calculating the infinite series formula, the value of x and 
    // the n for the number of iterations, or number of exponents.
    class InfiniteSeries
    {
        public int x { get; set; }      // Property for x value for e^x
        public int n { get; set; }      // Property for number of iterations

        // Constructur which takes 2 integer paramaters, int X, which will be set
        // to the x property of the class for the exponent value, and int Y, which will
        // be set to the y property of the class for the iteration value.
        public InfiniteSeries(int X, int N)
        {
            // Initialize the properties to the arguments passed
            x = X;
            n = N;
        }

        // The Calculate method calculates the exponent and factorial operations
        // based on the formula sum = 1 + (x / 1!) + (x^2 / 2!) ... (x^n / n! ).
        // The method calculates for all values of the property n, and calculates
        // the sum.
        public void Calculate()
        {
            double p = 1;            // Number to hold the product value
            double f = 1;            // Number to hold factorial value
            double sum = 1;          // Number to hold sum of values during the series operation
            int i = 1;               // Iteration value to control the while loop

            // This while loop is set to iterate until values of the exponents, factorials,
            // and the sum have been calculated. This loop performs the main calculation of the
            // program.
            while (i <= n)
            {
                p *= x;   // Calculates the product
                f *= i;   // Calculates the factorial
                sum += p / f;   // Adds the product divided by the factorial to the sum
                //   Console.WriteLine("I: {0}\tP = {1}\t\tF = {2}\t\tSum = {3}"
                //           , i, p, f, sum);   // Prints out the values
                i++;      // Increase iteration value
            }

            // Values to compare the while loop operations to the methods from the Math class
            double exp = Math.Pow(Math.E, x);   // The value of the calculation using the "e" value from the Math class
            double diff = sum - exp;   // The difference of sum and exp

            // Display the original input, the sum, exp, and their difference
            Console.WriteLine("x = {0};  n = {1}", x, n);
            Console.WriteLine("sum = {0}\nexp = {1}\ndiff = {2}", sum, exp, diff);
        } // end of Calculate method
        // Calculate method is called by the main method

    } // end of class InfiniteSeries

} // end namespace
